﻿/*
VERSION:		1.3
1.3		handlerDepth defaults to 2,  which is apparently safe for standard scroll-pane components
1.2		added "direction"  "positon"  to "scroll" evt object		(direction and positon are standard)  (diagonal scrolling emits 2 "scroll" events:  horizontal & vertical)

USAGE:
	#include "functions/addPanePan.as"
	addPanePan( my_pane, 2 );
*/
addPanePan = function( targetPane, handlerDepth )
{
	if( handlerDepth === undefined )		var handlerDepth = 2;
	var panePan = targetPane.createEmptyMovieClip("panePan", handlerDepth);
	panePan.lastPress = false;
	panePan.isPressed = false;
	panePan.lastPosition = new flash.geom.Point(0,0);
	panePan.onEnterFrame = function()
	{
		var middleClick = 4;
		if(Key.isDown(middleClick))
		{// if:  held
			if( targetPane.mask_mc.hitTest(_root._xmouse,_root._ymouse) )
			{// if:  cursor is over pane
				if(!panePan.lastPress)
				{// if:  onPress
					panePan.isPressed = true;
					panePan.lastPosition.x = _xmouse;
					panePan.lastPosition.y = _ymouse;
				}// if:  onPress
			}// if:  cursor is over pane
		}// if:  held
		else
		{// if:  not held
			if(panePan.lastPress)
			{// if:  onRelease
				panePan.isPressed = false;
			}// if:  onRelease
		}// if:  not held
		// remember button press for next time
		panePan.lastPress = (Key.isDown(middleClick));
	}// loop()
	
	panePan.onMouseMove = function()
	{
		if(panePan.isPressed)
		{// if:  dragging
			var currentPosition = new flash.geom.Point(_xmouse,_ymouse);
			var movement = panePan.lastPosition.subtract(currentPosition);		// measure movement
			// scroll
			targetPane.hPosition += movement.x;
			targetPane.vPosition += movement.y;
			// announce scroll
			// "direction" and "position" are standard.  "pixelCoords" is unique to panePan
			if(movement.x !== 0){
				targetPane.dispatchEvent({type:"scroll", direction:"horizontal", position:targetPane.hPosition});
			}
			if(movement.y !== 0){
				targetPane.dispatchEvent({type:"scroll", direction:"vertical", position:targetPane.vPosition});
			}
			//targetPane.dispatchEvent({type:"scroll", pixelCoords:{x:targetPane.hPosition, y:targetPane.vPosition}});
			// remember position for next time
			panePan.lastPosition.x = _xmouse;
			panePan.lastPosition.y = _ymouse;
		}// if:  dragging
	}// onMouseMove()
}// addPanePan()